﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using BaiqiSoft.HtmlEditorControl;

namespace Demo
{
    public partial class frmLinkStyleSheet : Form
    {
        public frmLinkStyleSheet()
        {
            InitializeComponent();

            //Added to support default instance behavour in C#
            if (defaultInstance == null)
                defaultInstance = this;
        }

        #region Default Instance

        private static frmLinkStyleSheet defaultInstance;

        public static frmLinkStyleSheet Default
        {
            get
            {
                if (defaultInstance == null)
                {
                    defaultInstance = new frmLinkStyleSheet();
                    defaultInstance.FormClosed += new FormClosedEventHandler(defaultInstance_FormClosed);
                }

                return defaultInstance;
            }
        }

        static void defaultInstance_FormClosed(object sender, FormClosedEventArgs e)
        {
            defaultInstance = null;
        }

        #endregion

        private void frmLinkStyleSheet_Load(object sender, EventArgs e)
        {
            lstURL.Items.Clear();
            foreach (StyleSheetLink stylesheet in frmMain.Default.HtmlEditor1.StyleSheetLinks)
            {
                lstURL.Items.Add(stylesheet.href);
            }
            if (lstURL.Items.Count > 0)
            {
                btnRemove.Enabled = true;
                btnEdit.Enabled = true;
            }
            else
            {
                btnRemove.Enabled = false;
                btnEdit.Enabled = false;
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            frmSelectFile.Default.txtURL.Text = "";
            frmSelectFile.Default.ShowDialog();
            if (clsGlobal.returnValue.Length > 0)
            {
                lstURL.Items.Add(clsGlobal.returnValue);
            }
            if (lstURL.Items.Count > 0)
            {
                btnRemove.Enabled = true;
                btnEdit.Enabled = true;
            }
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            if (lstURL.SelectedItem == null)
                return;
            lstURL.Items.Remove(lstURL.SelectedItem);
            if (lstURL.Items.Count == 0)
            {
                btnRemove.Enabled = false;
                btnEdit.Enabled = false;
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lstURL.SelectedItem == null)
                return;
            frmSelectFile.Default.txtURL.Text = lstURL.SelectedItem.ToString();
            frmSelectFile.Default.ShowDialog();
            if (clsGlobal.returnValue.Length > 0)
            {
                lstURL.Items[lstURL.SelectedIndex] = clsGlobal.returnValue;
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            frmMain.Default.HtmlEditor1.StyleSheetLinks.Clear();
            foreach (string item in lstURL.Items)
            {
                frmMain.Default.HtmlEditor1.StyleSheetLinks.Add(item);
            }
            this.Close();
        }
    }
}
